%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This work by EPFL STI IBI LBNI is licensed under 
% a Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
% Based on a work at http://lbni.epfl.ch/.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function [im, peak_2_gaussian_std, peak_2_gaussian_ampl, improv_param] = medianCorrection2(im, peak_gaussian_ini_std, peak_gaussian_ini_ampl, min_spacing_stdev, max_spacing_stdev, amplitude_fract,  min_peak_distance, min_peak_height, peak_threshold, position_est, peak_height_est, peak_index_est, peak_pos_tolerance, histogram_bins, smoothing_level, min_hist, max_hist, ref_peak_pos, peaks_fit,j,S,index)
%Function medianCorrection: 
%Applies to the image im a median correction and a median
%diff correction
%   Input parameters:
%       - im: current image
%       - tolerance_std: for the condition: if abs(diff_line_mean(i)) >= mean(diff_line_mean) + tolerance_std*std(diff_line_mean)
%       - peak_gaussian_ini_std, peak_gaussian_ini_ampl: initial stds and
%       amplitudes of each peak
%       - min_spacing_stdev, max_spacing_stdev: defined at the beginning of
%           Nano6_Flatten_surf_poly
%       - amplitude_fract,  min_peak_distance, min_peak_height, peak_threshold: 
%       parameters to correctly find the peaks in the histogram
%       - position_est, peak_height_est, peak_index_est: parameters of
%           the estimated peaks in order to identify the peaks correctly
%       - peak_pos_tolerance: to identify correctly the corresponding peaks
%   Output parameters:
%       - im: new image after median correction
%       - improv_param: positive in case of improvement, else negative
%       - peak_2_gaussian_std, peak_2_gaussian_ampl: new standard deviations and
%         amplitudes for each peak

% Line Match Correction with scar correction
%% Severine's initial version
%     image_comp_test                             = zeros(size(im));
%     line_median                                 = zeros(size(im,1),1);
%     diff_line_median                            = zeros(size(im,1)-1,1);
%     clear A
%    
%     for i                                       = 1:size(im,1)                                                                                                                  % Loops for the number of scanlines                                                            % Subtracts line median each scan line
%         line_median(i)                          = median(im(i,1:size(im,2)));
%     end
%     diff_line_median                            = diff(line_median)-median(diff(line_median));
%     scar_thresh                                 = 2*std(diff_line_median);
%     
%     image_comp_test(1,1:size(im,2))             = im(1,1:size(im,2)) - median(im(1,1:size(im,2)));
%     
%     for i                                       = 2:length(diff_line_median)                                                                                                                  % Loops for the number of scanlines
%         if abs(diff_line_median(i))             < scar_thresh 
%             A                                   = im(i+1,1:size(im,2)) - image_comp_test(i,1:size(im,2));
%             image_comp_test(i+1,1:size(im,2))   = im(i+1,1:size(im,2)) - median(A(mean(A) - 2*std(A) <= A & A <= mean(A) + 2*std(A)));                                                              % Subtracts line median each scan line
%         else
%             for k                               = 1:size(im,2)
%                 image_comp_test(i+1,k)          = median(image_comp_test(max([find(abs(diff_line_median(1:i)) < scar_thresh,1,'last'),1]),max([1,k-2]):min([k+2,size(im,2)])));
%             end
%         end 
%     end
%     
%     im = image_comp_test;
%% Blake's Updated Version Nov 9, 2011
image_comp_test                             = zeros(size(im));
line_median                                 = zeros(size(im,1),1);
diff_line_median                            = zeros(size(im,1)-1,1);
clear A

for i                                       = 1:size(im,1)                                                                                                                  % Loops for the number of scanlines                                                            % Subtracts line median each scan line
    line_median(i)                          = median(im(i,1:size(im,2)));
end
diff_line_median                            = diff(line_median)-median(diff(line_median));


image_comp_test(1,:)                        = im(1,:) - median(im(1,:));

for i                                       = 2:length(diff_line_median)                                                                                                                % Loops for the number of scanlines
        A                                   = im(i,:) - image_comp_test(i-1,:);
        image_comp_test(i,:)                = im(i,:) - median(A(median(A) - 2*std(A) <= A & A <= median(A) + 2*std(A)));                                                              % Subtracts line median each scan line
end

search_span                                 = 15;
for k                                       = 1:4
for i                                       = 2:size(im,1)
    diff_counter                            = zeros(1,size(im,2));
    for j                                   = max([1,i-search_span]):i-1
        diff_counter                        = diff_counter + (image_comp_test(i,:)-image_comp_test(j,:));
    end
    image_comp_test(i,:)                    = image_comp_test(i,:)-(median(diff_counter(median(diff_counter) - 2*std(diff_counter) <= diff_counter & diff_counter <= median(diff_counter) + 2*std(diff_counter))))/length(max([1,i-search_span]):i-1);
end

for i                                       = size(im,1)-1:-1:1
    diff_counter                            = zeros(1,size(im,2));
    for j                                   = i+1:min([size(im,1),i+search_span])
        diff_counter                        = diff_counter + (image_comp_test(i,:)-image_comp_test(j,:));
    end
    image_comp_test(i,:)                    = image_comp_test(i,:)-(median(diff_counter(median(diff_counter) - 2*std(diff_counter) <= diff_counter & diff_counter <= median(diff_counter) + 2*std(diff_counter))))/length(i+1:min([size(im,1),i+search_span]));
end
end

im                                          = image_comp_test;
%% Improvement Check    
% Checks if the whole median correction improved the image
   [improv_param, peak_2_gaussian_std, peak_2_gaussian_ampl] = check_improvement(   im, peak_gaussian_ini_std, peak_gaussian_ini_ampl, ...
                                                                                    min_spacing_stdev, max_spacing_stdev, amplitude_fract, min_peak_distance, ...
                                                                                    min_peak_height, peak_threshold, position_est, peak_height_est, peak_index_est, ...
                                                                                    peak_pos_tolerance, histogram_bins,smoothing_level, min_hist, max_hist, ref_peak_pos, peaks_fit,j,S,index);  % Second of third median correction, so check looks at the std of each peak of the histogram
end
